/*!
 * Copyright (c) 2005, Freescale Semiconductor
 *
 * Freescale Confidential Proprietary
 * \file    mcu_hw_config.c
 * \brief   MCU Hardware configuration routines.
 * \author  a20639
 * \version 4.1a
 * \date    2005/08/11 20:44:37 
 * 
 * \b Description:
 *
 * This file contains the functions to manage the clock, 
 * COP, GPIO, SPI and IRQ. 
 *
 * \b Department: Freescale Radio Products Division 
 *
 * \b Project: SMAC (Simple Media Access Controller)
 *
 * \b History:
 * - 11/16/2005 Doc. update to Doxygen compliant by Gonzalo Delgado 
 * Huitron rgd04c
 */ 
 


#include "smac_mcu_hw_config.h"
#include "smac_simple_phy.h"
#include "smac_mcu_spi_config.h"
#include "smac_drivers.h"
#include "mcf5271_gpio.h"
#include "mcf5271_intc0.h"
#include "mcf5271.h"
#include "hardware.h"
#include <nucleus.h>
#include <nutypedefs.h>
#include "errors.h"


#include "hprfgw_rfSharedDefs.h"
#include "hprfgw_rfSlaveIntToHost.h"
#include "hprfgw_rfSlaveIntToRfApp.h"



/*! Global Variables */

// ISR Details
#define MC13192PHY_INTLEV		       (MCF_INTC0_ICRn_IL(6)|MCF_INTC0_ICRn_IP(7))  // fixed because it's an Ext Interrupt
#define MC13192PHY_VECT			       (70)	
#define MC13192_HISR_PRIORITY      (1)


/* Defines */
// For now, hardcode the values. Use the coldfire .h files later on
	// RxTx, Attn, PAEnable, AnswTxEn, AntSwRxEn, GPIO5, GPIO6, Reset pin mask 
// These are specific to the HPRFGW
	#define gMC1319xRxTxMask_c   		(1<<0)							
	#define gMC1319xAttnMask_c   		(1<<1)							
	#define gMC1319xPAEnMask_c  		(1<<2)							 
	#define gMC1319xAntSwTxEnMask_c  	(1<<3)							 
	#define gMC1319xAntSwRxEnMask_c  	(1<<4)							 
	#define gMC1319xGPIO5Mask_c  		(1<<5)							 
	#define gMC1319xGPIO6Mask_c  		(1<<6)		 
	#define gMC1319xResetMask_c  		(1<<7)							


	//	GPIO1, GPIO2, GPIO3, GPIO4 pin mask	
	#define gMC1319xGPIO1Mask_c  		(1<<1)							
	#define gMC1319xGPIO2Mask_c 		(1<<2)							
	#define gMC1319xGPIO3Mask_c 		(1<<3)							
	#define gMC1319xGPIO4Mask_c 		(1<<4)				




RFPHYISRSTRUCT RFPhyISR;



////////////////////////////////////////////////////////////////////////////////
//	EXTERNAL FUNCTIONS 
///////////////////////////////////////////////////////////////////////////////
extern void EnableInterrupt(BOOL hi, UINT32 mask);




/*
 * MC13192Restart: Restart the MC13192.
 *
 * Parameters: None
 *
 * Return : None
 */
void MC13192Restart()
{
//UINT8 u8AttnIrq =0; //mod
//UINT16 u8AttnIrq = 0; //mod

    gu8RTxMode = SYSTEM_RESET_MODE;
    
    // MNT - 4/5/2007 - Assert the reset?
    /// \review this = this should be cleaned up
    MC13192_IRQ_Disable();
    MC1319xDrv_Assert_Reset();
    SMAC_IRQInit();                  /* Turn on the IRQ pin. */
    MC1319xDrv_Deassert_Reset();          /* Take MC13192 out of reset */
    while (IRQFLAG() == 0)     /* Poll waiting for MC13192 to assert the irq */
        ; /* Empty Body */      /* (i.e. ATTN). */
    (void)SPIDrvRead(0x24);            /* Clear MC13192 interrupts */
    IRQACK();                   /* ACK the pending IRQ interrupt */
    IRQPinEnable();             /* Pin Enable, IE, IRQ CLR, negative edge. */    
}


/*
 * MC13192ContReset: Reset (continuous) the MC13192.
 *
 * Parameters: None
 *
 * Return : None
 */
void MC13192ContReset()
{
    gu8RTxMode = SYSTEM_RESET_MODE;
//    IRQSC = 0x00;                   /* Set for negative edge. */
    MC1319xDrv_Assert_Reset();              /* Place the MC13192 into reset */
}



/*!
  \fn void GPIOInit()
  \brief Initialize the MCU-to-MC13192 GPIO direction and data.
*/
void SMAC_GPIOInit()
{
	  GPIO_5271_Regs *gpio = get_gpio_ptr();

	  // MNT - 4/5/2007 - Set up RxTx, Attn, PAEnable, AnswTxEn, AntSwRxEn, GPIO5, GPIO6, Reset
    // as outputs
    gpio->pddr_datah	= 
      gMC1319xRxTxMask_c | 
      gMC1319xAttnMask_c |
      gMC1319xPAEnMask_c |
      gMC1319xAntSwTxEnMask_c |
      gMC1319xAntSwRxEnMask_c |
      gMC1319xGPIO5Mask_c |
      gMC1319xGPIO6Mask_c |
      gMC1319xResetMask_c;		
	

    // Disable Tx / Rx  and ATTN (all active low signals)
	gpio->podr_datah	= 
    gMC1319xAntSwRxEnMask_c |
    gMC1319xAntSwTxEnMask_c | 
    gMC1319xAttnMask_c;
  //gpio->podr_datah	= (gMC1319xResetMask_c|gMC1319xAntSwRxEnMask_c|gMC1319xAntSwTxEnMask_c|gMC1319xAttnMask_c);

  // Set All the CS lines to GPIO (these are GPIO 1-4 from the radio)
	gpio->par_cs		= 0x00;
  // Set the direction of the 4 GPIO pins to input
	gpio->pddr_cs	   &= ~(gMC1319xGPIO1Mask_c|gMC1319xGPIO2Mask_c|gMC1319xGPIO3Mask_c|gMC1319xGPIO4Mask_c); 	
 
}


/**
 *
 * \date        04-05-2007
 *
 * \author      MNT - Adapted from HS
 *
 * \brief       Assert the reset pin
 *
 * \detail      Active Low
 *
 * \return      Nothing
 *
 * \retval      
 *
 * \param void 
 */
#pragma inline MC1319xDrv_Assert_Reset
void MC1319xDrv_Assert_Reset(void)	{
	GPIO_5271_Regs *gpio = mcf5271_gpio_ptr();
#ifdef	TPS6_CLIENT_TEST
	gpio->podr_datal  &= ~gMC1319xResetMask_c;
#else
	gpio->podr_datah  &= ~gMC1319xResetMask_c;
#endif
}

/**
 *
 * \date        04-05-2007
 *
 * \author      MNT - Adapted from HS
 *
 * \brief       Deassert the reset pin
 *
 * \detail      Active Low
 *
 * \return      Nothing
 *
 * \retval      
 *
 * \param void 
 */
#pragma inline MC1319xDrv_Deassert_Reset
void MC1319xDrv_Deassert_Reset(void)	{
	GPIO_5271_Regs *gpio = mcf5271_gpio_ptr();
#ifdef	TPS6_CLIENT_TEST
	gpio->podr_datal |= gMC1319xResetMask_c;
#else
	gpio->podr_datah |= gMC1319xResetMask_c;
#endif
}




/**
 *
 * \date        04-05-2007
 *
 * \author      mtalreja
 *
 * \brief       IRQFLAG
 *
 * \detail      Indicates if the interrupt has occured. Returns true if IRQ line is 0
 *
 * \return      UINT8
 *
 * \retval      1 - Occured
 *              0 - Not Occured
 *
 * \param void 
 * \return 
 */
#pragma inline IRQFLAG
UINT8 IRQFLAG(void)
{
	EPORT_5271_Regs* eport = mcf5271_eport_ptr();
	return (!(eport->eport_pin_data_reg & MCF_EPORT_EPFR_EPF6));  
}










/**
 *
 * \date        04-05-2007
 *
 * \author      mtalreja
 *
 * \brief       Initialize the IRQ6
 *
 * \detail      
 *
 * \return      
 *
 * \retval      
 *
 * \param void 
 */
#pragma inline SMAC_IRQInit
void SMAC_IRQInit(void)
{
  EPORT_5271_Regs* eport = mcf5271_eport_ptr();
	INTCx_5271_Regs *intc0 = mcf5271_intc0_ptr();
	void (*old_lisr)(INT);
  STATUS status;

	// Create LISR for MC13192 PHY chip at External interrupt IRQ6 
	if (NU_SUCCESS != NU_Register_LISR(MC13192PHY_VECT, MC13192_LISR, &old_lisr))	
  {
		SystemError (FATAL_RF_INIT);
	}

  status = NU_Create_HISR(&RFPhyISR.RfPhyHISR, "RFPHYHI", MC13192_HISR, MC13192_HISR_PRIORITY,
    RFPhyISR.RfPhyHISRStack, sizeof(RFPhyISR.RfPhyHISRStack));
    if (status != NU_SUCCESS)
    {
        SystemError (FATAL_RF_INIT);
    }


  // MNT - 4/5/2007 - Clean this up
  /// \review - Set up as level sensitive interrupt?
  eport->eport_pin_assign_reg |= MCF_EPORT_EPPAR_EPPA6(MCF_EPORT_EPPAR_EPPAx_FALLING);

	//	Set interrupt level	
	intc0->icr_ext_int6 =  MC13192PHY_INTLEV;
	//	Enable vector interrupt 
	EnableInterrupt(FALSE,  MCF_IMRL_EXT_INT6);
	//	Enable global vector interrupt
	EnableInterrupt(FALSE, MCF_INTC0_IMRL_MASKALL); 


}



#pragma inline MC13192_IRQ_Disable
void MC13192_IRQ_Disable(void)
{
	EPORT_5271_Regs* eport = mcf5271_eport_ptr();
	int old_level;

  /// \review - HS mentioned that we need to disable all interrupts
  /// before disabling our interrupt to prevent "spurious" interrupts
  /// Investigate this
	old_level = NU_Local_Control_Interrupts(NU_DISABLE_INTERRUPTS);	
	eport->eport_interrupt_ena_reg &= ~MCF_EPORT_EPFR_EPF6;
	NU_Local_Control_Interrupts(old_level);


}

#pragma inline MC13192_IRQ_Enable
void MC13192_IRQ_Enable(void)
{
  EPORT_5271_Regs* eport = mcf5271_eport_ptr();
	
  // MNT - 4/5/2007 - Clean this up
  /// \review - Set up as level sensitive interrupt?
  eport->eport_interrupt_ena_reg |= MCF_EPORT_EPFR_EPF6;

}




#pragma inline IRQPinEnable
void IRQPinEnable(void)
{
  MC13192_IRQ_Enable();
}


#pragma inline IRQACK
void IRQACK(void)
{
	EPORT_5271_Regs* eport = mcf5271_eport_ptr();
  eport->eport_flags_reg |= MCF_EPORT_EPFR_EPF6;
}




// MNT - 7/11/07 - Moved the SMAC_MCU_Init to smac_app.c. This function did not have
// any processor specific code. Moving to smac_app.c allows control of this file without
// affecting the hardware specific stuff. 



 /*!
  \fn UINT8 IRQPinLow() 
  \brief	Checks IRQ Pin to see if is low.
  \return	1 if IRQ is Low   
   
*/
#pragma inline IRQPinLow
UINT8 IRQPinLow(void){

    //asm  BIL irq    
    //return 0;    
    //asm irq:    
    //return 1;
  return IRQFLAG();
}

//#pragma INLINE
//void AssertCE(void){
//  MC13192_CE = 0; /*!< Asserts the MC13192 CE pin */
//}
//#pragma INLINE
//void DeAssertCE(void){
//  MC13192_CE = 1; /*!< Deasserts the MC13192 CE pin */
//}
#pragma inline RTXENDeAssert
void RTXENDeAssert(void){
	GPIO_5271_Regs *gpio = mcf5271_gpio_ptr();
#ifdef	TPS6_CLIENT_TEST
	gpio->podr_datal  &= ~gMC1319xRxTxMask_c;
#else
	gpio->podr_datah  &= ~gMC1319xRxTxMask_c;
#endif

}
#pragma inline RTXENAssert
void RTXENAssert(void){
	GPIO_5271_Regs *gpio = mcf5271_gpio_ptr();
#ifdef	TPS6_CLIENT_TEST
	gpio->podr_datal  |= gMC1319xRxTxMask_c;
#else
	gpio->podr_datah  |= gMC1319xRxTxMask_c;
#endif
}

#pragma inline MC13192Wake
void MC13192Wake(void){
	GPIO_5271_Regs *gpio = mcf5271_gpio_ptr();
  /*!< Assert ATTN */ 
#ifdef	TPS6_CLIENT_TEST
	gpio->podr_datal  |= gMC1319xAttnMask_c;
#else
	gpio->podr_datah  |= gMC1319xAttnMask_c;
#endif

  /*!< Deassert ATTN */
#ifdef	TPS6_CLIENT_TEST
	gpio->podr_datal  &= ~gMC1319xAttnMask_c;
#else
	gpio->podr_datah  &= ~gMC1319xAttnMask_c;
#endif

}



#pragma inline MCU_LOW_POWER_WHILE
void MCU_LOW_POWER_WHILE(void)
{
    /* Execute the stop instruction */
	//asm (stop #0x2000);
	RFIntHostApp.pF_HwDelayUsec(10);
	
}




// MNT - 4/6/2007 - QSPI CS is now configured as a GPIO
#pragma inline AssertCE
void AssertCE(void)
{
	GPIO_5271_Regs *gpio = get_gpio_ptr();
  gpio->podr_qspi &= ~MCF_GPIO_PPDSDR_QSPI_PPDSDR_QSPI3;
}
#pragma inline DeAssertCE
void DeAssertCE(void)
{
	GPIO_5271_Regs *gpio = get_gpio_ptr();
  gpio->podr_qspi |= MCF_GPIO_PPDSDR_QSPI_PPDSDR_QSPI3;
}





#pragma inline MC1319xDrv_TxHighPowerEnable
void MC1319xDrv_TxHighPowerEnable(void)	{
	GPIO_5271_Regs *gpio = mcf5271_gpio_ptr();
#ifdef	TPS6_CLIENT_TEST
	gpio->podr_datal  |= gMC1319xPAEnMask_c;
#else
	gpio->podr_datah  |= gMC1319xPAEnMask_c;
#endif
}

#pragma inline MC1319xDrv_TxHighPowerDisable
void MC1319xDrv_TxHighPowerDisable(void)	{
	GPIO_5271_Regs *gpio = mcf5271_gpio_ptr();
#ifdef	TPS6_CLIENT_TEST
	gpio->podr_datal  &= ~gMC1319xPAEnMask_c;
#else
	gpio->podr_datah  &= ~gMC1319xPAEnMask_c;
#endif
}

#pragma inline MC1319xDrv_RxAntennaSwitchEnable
void MC1319xDrv_RxAntennaSwitchEnable(void) { 
	GPIO_5271_Regs *gpio = mcf5271_gpio_ptr();
	MC1319xDrv_TxHighPowerDisable();
#ifdef	TPS6_CLIENT_TEST
	gpio->podr_datal  |= gMC1319xAntSwTxEnMask_c;
	gpio->podr_datal  &= ~gMC1319xAntSwRxEnMask_c;
#else
	gpio->podr_datah  |= gMC1319xAntSwTxEnMask_c;
	gpio->podr_datah  &= ~gMC1319xAntSwRxEnMask_c;
#endif
}
#pragma inline MC1319xDrv_TxAntennaSwitchEnable
void MC1319xDrv_TxAntennaSwitchEnable(void) { 
	GPIO_5271_Regs *gpio = mcf5271_gpio_ptr();
	MC1319xDrv_TxHighPowerEnable();
#ifdef	TPS6_CLIENT_TEST
	gpio->podr_datal  |= gMC1319xAntSwRxEnMask_c;
	gpio->podr_datal  &= ~gMC1319xAntSwTxEnMask_c;
#else
	gpio->podr_datah  |= gMC1319xAntSwRxEnMask_c;
	gpio->podr_datah  &= ~gMC1319xAntSwTxEnMask_c;
#endif
}




#pragma inline MC13192ReadGPIOStatus
/**
 *
 * \date        01-21-2008
 * \author      mtalreja
 * \brief       MC13192ReadGPIOStatus
 * \detail      Returns the GPIO status in the lower 3 bits - data is in PPDSDR register
 * \return      0 = low, 1 = high
 * \retval      
 * \warning     
 * \note        
 *
 * \param void 
 * \return 
 */
UINT8 MC13192ReadGPIO1_3Status(void)
  {
    UINT8 retval;
	  GPIO_5271_Regs *gpio = mcf5271_gpio_ptr();
    
    // MNT - 1/21/2008 - read the register, shift it to correct location and 
    // mask off all bits other than the lower 3 bits
    retval = ((gpio->ppdsdr_cs) >> 1) & 0x7;
    
    return retval;
  }
